;
// Interval in miliseconds to pull last message in the logger
const POP_TIME = 20000;
const INSTRUCTIONS_TIMEOUT = 9000;
const POINTS_TO_GROW = 20;

let GAME = {
  isInstalled: false
};

// Init the localStorage vault for the game
window.vault = Vault.init('fruitpick');

  // todo: if not webxr dont start
window.canBootstrap = 'navigator' in window
  && 'geolocation' in window.navigator
  // Property set at: is-mobile.js
  && window.isMobile;

window.connectionVelocity = getConnectionVelocity();

// todo: if network ocnnection slow basic performance
// todo: if desktop show only mobile
// Guess the device performance to render a solid color material or a texture
window.basicRendering = !'navigator' in window
  // slow memory
  || (navigator.deviceMemory <= 2 
  && navigator.hardwareConcurrency <= 8) 
  || (navigator.connectionVelocity == 'slow');

window.environment = 'production';


// Fruits Generator URL, toggles between remote WS and local JSON for offline fun
const OFFLINE_API_URL = '/fruitpick/ws/fruits'; // fruits amount is appended on fetch()
const WS_URL = 'https://ws.devignia.site/api/fruitpick';

window.apiUrl = navigator.onLine ? WS_URL : OFFLINE_API_URL;

window.addEventListener('online', function() {
  window.apiUrl = WS_URL;
});
window.addEventListener('offline', function() {
  window.apiUrl = OFFLINE_API_URL;
});

// Animation for every new location update, disabled for basic performance devices
window.followAnimation = !window.basicRendering;

// i18n
const i18nfp = window.i18n();
i18nfp.setMessages(
  'fruitpick',
  'en',
  gameStrings,
  'nplurals=1; plural=n>1;'
);
i18nfp.setLocale('en');

// Service Worker
/*
if ("serviceWorker" in navigator) {
			window.addEventListener("load", () => {
				navigator.serviceWorker && navigator.serviceWorker.register("/fruitpick/js/sw.js");
			});
}
	*/
function getConnectionVelocity() {
  if (!'connection' in navigator || window.connection == undefined)
    return 'good'; // defaults to acceptable connection type
  
  let type = navigator.connection.type,
    effectiveType = navigator.connection.effectiveType,
    downlink = navigator.connection.downlink / 1024,
    saveData = navigator.connection.saveData;
  
  /*
    // Set Connection Velocity for models specs
    navigator.connection.addEventListener('change', function() {
      window.connectionVelocity = getConnectionVelocity(); 
    });
  */
  // The goods
  if (['wifi', 'wimax', 'cellular'].contains(type) && downlink > 2)
    return 'good';
  
  // And the not so...
  if (['bluetooth', 'none', 'other', 'unknown'].contains(type) || downlink < 2)
    return 'slow';
  
  if (['slow-2g', '2g', '3g', '4g'].contains(effectiveType) || saveData)
    return 'slow';
  
}

window.verbose = false;
window.debug = false;
window.descriptor = {};

document.addEventListener('ready', function() {
  
  // Remove fallback section.offline    
  document.querySelector('section.offline').remove();
});

// URL common call
// https://ws.devignia.site/api/fruitpick/fruits?latitude=62.76&longitude=25.62