(function(win, doc, navi, vue, perms, geo) {
  const btnLocation = doc.querySelector('button.btn-location'),
    btnCamera = doc.querySelector('button.btn-camera'),
    lang = {
      available: {
		  en: 'English',
		  es: 'Spanish',
	  },
      default: 'en',
      browser: navi.language.substring(0, 2),
    },
    { createApp } = vue
  ;
  
   
  
  doc.querySelector('section.guide')
        .removeAttribute('hidden');
  
  const ob = createApp({
    data: () => ({
      lang: lang.available.hasOwnProperty(lang.browser) ? lang.browser : lang.default,
      cameraState: 'default',
      locationState: 'default',
      step: 1,
      cameraBtnClasses: '',
      locationBtnClasses: '',
      wlang: navi.language,
      // canProceed: computed
      // lang: computed
    }),
    computed: {
      canProceed() {
        return !(this.locationState !== 'granted') && !(this.cameraState !== 'granted') ? true : false;
      },
	  lblLang() {
		  return lang.available[this.lang]
	  },
    },
    watch: {
      cameraState(s, p) {
        
        switch(s) {
          case 'granted':
            this.cameraBtnClasses = 'btn-success';
          break;
          case 'prompt':
            this.cameraBtnClasses = 'btn-secondary';
          break;
          case 'denied':
            this.cameraBtnClasses = 'btn-danger';
          break;
          default:
            this.cameraBtnClasses = 'btn-secondary';
          break;
        }
      },
      locationState(s, p) {
        switch(s) {
          case 'granted':
            this.locationBtnClasses = 'btn-success';
          break;
          case 'prompt':
            this.locationBtnClasses = 'btn-secondary';
          break;
          case 'denied':
            this.locationBtnClasses = 'btn-danger';
          break;
          default:
            this.locationBtnClasses = 'btn-secondary';
          break;
        }
      },
    },
    methods: {
      enableCamera(ev) {
        perms.query({name: 'camera'}).then((ev) => {
          this.cameraState = ev.state;
          navigator.mediaDevices.getUserMedia({
            audio: false,
            video: true
          }).then(() => {
            this.cameraState = ev.state;  
          })
        }).catch((e) => {
          this.cameraState = 'denied';
        })
      },
	  t9(key) {
		  return gameStrings[this.lang] ? (gameStrings[this.lang][key] || key) : key
	  },
      enableLocation(ev) {
        perms.query({name: 'geolocation'}).then((ev) => {
          this.locationState = ev.state;
          navigator
            .geolocation
            .getCurrentPosition((res) => {
              this.locationState = 'granted';
            }, (res) => {
              this.locationState = 'denied';
            });
        }).catch((e) => {
          this.locationState = 'denied';
        })
      }
    },
    created() {
      // Permissions preflight
      perms.query({ name: 'geolocation' }).then((ev) => {
          this.locationState = ev.state;
      })
      
      perms.query({ name: 'camera' }).then((ev) => {
        this.cameraState = ev.state;
      })
      
    },
    
  }).mount('main');
  
  
  
})(window, document, navigator, Vue, navigator.permissions, navigator.geolocation);
