;
const { createApp } = Vue;

let statusBar = createApp({
  data: () => ({
    
    msgs: [],
    points: 0,
    pointsLabel: '',
    loggerInterval: false,
    bouncyText: false,
    lang: false,
    online: navigator.onLine // Just a reference to navgator property
  }),
  methods: {
    log(msg, className) {
      this.msgs.push({ msg, className });
      
      // Every time a log is added, schedule its removal
     setTimeout(function() {
        statusBar.msgs.splice(0, 1);
      }, POP_TIME);
    },
    setPoints(points) {
      // this.points += parseInt(points); // points may come from a string src so integer cast
      this.pointsLabel = `${points} <small>points</small>`;
      this.bouncyText = true;
      setTimeout(function() {
        statusBar.bouncyText = false;
      }, 500);
    },
    setOnline() {
      this.online = navigator.onLine;
    },
    setInstructions() {
      const className = 'text-large';
      const instructions = [
        i18nfp.gettext("🤳 Look around with your device to find fruits."),
        i18nfp.gettext("Tap a fruit 👆 to feed the cat."),
      ].forEach((msg, key) => {
        setTimeout(function() {
          statusBar.log(msg, className)
        }, INSTRUCTIONS_TIMEOUT * (key + 2));
      });
      
      setTimeout(function() {
        statusBar.log(i18nfp.gettext("Keep walking to find more fruits on your path!"), 'text-large');
      }, 30000);
    }
  },
  created() {
    this.lang = i18nfp;
  },
  mounted() {
    this.pointsLabel = vault.get('points', 0) + ' <small>pts</small>';
    this.log(this.lang.ngettext("Let's go Fruit Picking!"));
    this.setInstructions();
    
  }
}).mount('#status-bar');

window.addEventListener('online', function() { statusBar.setOnline(); });
window.addEventListener('offline', function() { statusBar.setOnline(); });
