(function(win, doc, navi, vue, perms, geo, lucide) {
    const btnLocation = doc.querySelector('button.btn-location'),
        btnCamera = doc.querySelector('button.btn-camera'),
        lang = {
            available: {
                en: 'English',
                es: 'Spanish',
            },
            default: 'en',
            browser: navi.language.substring(0, 2),
        },
        GAME_DIR = '/fruitpick',
        { createApp } = vue;
    
    
    
    doc.querySelectorAll('[hidden]').forEach((item) => {
        item.removeAttribute('hidden');
	});
    
    const ob = createApp({
        data: () => ({
            lang: lang.available.hasOwnProperty(lang.browser) ? lang.browser : lang.default,
            cameraState: 'default',
            locationState: 'default',
            step: 1,
            cameraBtnClasses: '',
            locationBtnClasses: '',
            wlang: navi.language,
            // canProceed: computed
            // lang: computed
        }),
        computed: {
            canProceed() {
                return (this.locationState !== 'denied' && this.cameraState !== 'denied');
            },
            lblLang() {
                return lang.available[this.lang]
            },
        },
        watch: {
            cameraState(s, p) {
                switch (s) {
                    case 'granted':
                        this.cameraBtnClasses = 'btn-success';
                        break;
                    case 'denied':
                        this.cameraBtnClasses = 'btn-danger';
                        break;
                    default: // 'prompt' state and other possibilities
                        this.cameraBtnClasses = 'btn-secondary';
                        break;
                }
            },
            locationState(s, p) {
                switch (s) {
                    case 'granted':
                        this.locationBtnClasses = 'btn-success';
                        break;
                    case 'denied':
                        this.locationBtnClasses = 'btn-danger';
                        break;
                    default: // 'prompt' state and other possibilities
                        this.locationBtnClasses = 'btn-secondary';
                        break;
                }
            },
        },
        methods: {
            enableCamera() {
                perms.query({ name: 'camera' }).then((ev) => {
                    this.cameraState = ev.state;
                    navigator.mediaDevices.getUserMedia({
                        audio: true,
                        video: true
                    }).then((stream) => {
                        this.cameraState = 'granted';
                    }).catch((e) => {
						this.cameraState = 'denied';
					});
                }).catch((e) => {
                    this.cameraState = 'denied';
                });
            },
            
            enableLocation() {
                perms.query({ name: 'geolocation' }).then((ev) => {
                    this.locationState = ev.state;
                    
                    navigator
                        .geolocation
                        .getCurrentPosition((res) => {
                            this.locationState = 'granted';
                        }, (res) => {
                            this.locationState = 'denied';
                        });
                }).catch((e) => {
                    this.locationState = 'denied';
                })
            },
            t9(key) {
                return gameStrings[this.lang] ? (gameStrings[this.lang][key] || key) : key
            },
            startGame() {
                win.localStorage.setItem('onboarded', true);
                win.location.href = GAME_DIR;
            }
        },
        created() {
            // Permissions preflight
            perms.query({ name: 'geolocation' }).then((ev) => {
                this.locationState = ev.state;
            })
            
            perms.query({ name: 'camera' }).then((ev) => {
                this.cameraState = ev.state;
            })
            
            
            
        },
        updated() {
            lucide.createIcons();
			
        }
    }).mount('main');
    
    
    
})(window, document, navigator, Vue, navigator.permissions, navigator.geolocation, lucide);

// Game Bar for Vue
// Oct 2025
