;
AFRAME.registerComponent('pickable', {
    schema: {
        type: 'boolean'
    },
    after: ['gps-new-entity-place'],
    camera: false,
    events: {
        click: function(ev) {
            let position = this.el.object3D.position;
            const character = document.querySelector('#fp'),
                camera = document.querySelector('a-camera'),
                scene = this.el.sceneEl
				// @todo: confirm if rotation is not being used in this context
                // current = getFpModel(fpModels, character.dataset.totalPoints)
            ;
            character.setAttribute('look-at', position);
            
		let bite = new Howl({
			src: ['./sounds/01.mp3'],
			volume: 1,
			onend: function() { console.log('bite sound played') },
		});
		bite.play();
		console.log('sound');
            character.setAttribute('animation__001', `property: position; to: ${position.x} ${position.y} ${position.z}; dur: 680; easing: easeInOutExpo;`);
            character.setAttribute('animation__002', `property: rotation; to: 0 0 0; dur: 680; delay: 680; loop: false;`);
            
            character.addEventListener('animationcomplete__002', function() {
                character.removeAttribute('animation__001');
                character.removeAttribute('animation__002');
            });
            
			
        },
        obbcollisionstarted: function(ev) {
            if(!'pickable' in this.el.components) return;
            /*
            // prevent collision among fruits
            let withEl3D = this.el.object3D,
                wpos = withEl.position
            ;
            */
            
            let obbCompo = this.el.components['obb-collider'];
            
            
            obbCompo.obb.center.x += (obbCompo.obb.halfSize.x * 2);
            obbCompo.obb.center.y += (obbCompo.obb.halfSize.y * 2);
            obbCompo.obb.center.z += (obbCompo.obb.halfSize.z * 2);
            
           
        },
        obbcollisionended: function(ev){
            
        }
    }
});