;
AFRAME.registerComponent('preserve-location', {
  init: function() {
    
    let camera = document.querySelector('a-camera'),
      el = this.el,
      sceneEl = this.el.sceneEl;
    
    camera.addEventListener('gps-camera-update-position', function(ev) {
      // ev.detail.position contains 'latitude' and 'longitude' keys
      // position requires a valid latitude and longitude pair
      /*
      if(isValidPosition(ev.detail.position)) {
        statusBar.log('error')
        throw new Error(i18nfp.gettext('Position provided by GPS is not valid'));
        return false;
      }
      statusBar.log(JSON.stringify(ev.detail.position));
        */
      const loader = document.querySelector('.arjs-loader');
      //loader.classList.toggle('ready', !loader.classList.contains('ready'));
      loader.classList.add('ready');
      // ev.detail.position contains 'latitude' and 'longitude' keys
	  
      addFruitsAround(sceneEl, ev.detail.position);
      
      if (window.followAnimation) {
        let coords = camera.components['gps-new-camera'].threeLoc.lonLatToWorldCoords(
          ev.detail.position.longitude,
          ev.detail.position.latitude
        );
        
        el.setAttribute('animation', `property: position; to: ${coords[0]} ${el.object3D.position.y} ${coords[1]}; dur: 2380; loop: false; easing: easeInOutExpo;`);
        
      } else {
        
        el.setAttribute('gps-new-entity-place', ev.detail.position);
      }
      
    });
  }
});