export default FileReader = ((doc, navi) => {
    let input,
		form,
        legend = 'legend',
        fileContents		
    ;
    
    async function loadSvg(cb) {
        let file = input.files[0]
		if(file.type != "image/svg+xml")
			throw new Error('SVG file is required')
		
        legend.innerHTML = file.name
		cb(await file.text())

    }
    
    function mount(onchange, selector = 'form') {
        form = doc.querySelector(selector)
        legend = form.querySelector(legend)
        input = form.querySelector('input[type=file]')
        form.addEventListener('submit', (ev) => {ev.preventDefault()})
		
        input.addEventListener('change', () => {
			loadSvg(onchange)
		})
    }
    
    
    return { mount }
})(document, navigator)