export function getBoundingBoxes(grid) {
    let bBoxes = [];
    
    // Let's draw the grid
    for (let y = 1; y <= grid[1]; y++) {
        for (let x = 1; x <= grid[0]; x++) {
            
            bBoxes.push({
                tl: {
                    x: (1 / grid[0]) * (x - 1),
                    y: (1 / grid[1]) * (y - 1),
                },
                br: {
                    x: (1 / grid[0]) * x,
                    y: (1 / grid[1]) * y,
                }
            })
        }
    }
    
    return bBoxes;
}

export function getGridSection(point) {
    // setup sections
    let bBoxes = getBoundingBoxes(gridConfig)
    
    // detect betweens and return the bounding box and its human number
    let results = [];
    
    for (let i = 0; i < bBoxes.length; i++) {
        let bBox = bBoxes[i]
        if (
            point.x > bBox.tl.x &&
            point.x < bBox.br.x &&
            point.y > bBox.tl.y &&
            point.y < bBox.br.y
        )
            results.push({
                point,
                bBox,
                at: i + 1 // grid section number starting at 1
            })
    }
    
    return results;
}