export default FileReader = ((doc, navi) => {
    
    const MAX_SVG_SIZE_MB = 5;
    
    let input,
		      form,
        legend,
        fileContents,
        opts = {
            legend: 'legend',
            form: 'form'
        }
    ;
    
    
    
    
    async function loadSvg(cb) {
        let file = input.files[0]
        if(file.type != "image/svg+xml" || file.name.substr(-3).toLowerCase() != 'svg')
            throw Error('SVG file is required')
                
        if(file.size / 1024 / 1024 > MAX_SVG_SIZE_MB)
            throw Error(`SVG is larger in size, for optimal perforance please provide lower than ${MAX_SVG_SIZE_MB} MB`)
                
        legend.innerHTML = `Current svg: ${file.name}`
        
        const svgText = await file.text()
        
        if(svgText.search('<path') === -1)
            throw  Error('SVG does not contain valid <path /> nodes, please provide another one')
        
        cb(svgText)

    }
    
    function mount(onchange) {
        form = doc.querySelector(opts.form)
        legend = form.querySelector(opts.legend)
        input = form.querySelector('input[type=file]')
        form.addEventListener('submit', (ev) => {ev.preventDefault()})
		
        input.addEventListener('change', () => {
                    
        			loadSvg(onchange)
                    
        		})
    }
    
    
    return { mount }
})(document, navigator)